/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
function interiorStatisticsInit(dataObject, zyskiData) {
	var _container = $('#laptopTheContainer');
	var _tmpl = $('#statLapCont').html();
	var _init = true;

	$(window).on('hashchange.laptopStatistics', function() {
		$(window).off('resize.laptopStats');
		$(window).off('hashchange.laptopStatistics');
	});

	$(window).off('resize.laptopStats');
	$(window).on('resize.laptopStats', fx);

	function fx() {
		$('#statLapCont').css('display', 'none');
		var wWW = _container.width();
		var hHH = _container.height();
		if (_init && wWW <= 100) {
			window.setTimeout(fx, 0);
			return;
		}
		_init = false;
		$('#statLapCont').html(_tmpl);
		$('#statLapCont').css('display', 'block');

		jQuery('#statisticsComputerSlider').slidesjs({
			width: wWW,
			height: hHH,
			navigation: {
				active: false
			},
			pagination: {
				active: false
			}
		});

		// ============================ PROFITS PLOT ===============================

		function showTooltip(x, y, contents) {
			$("<div id='tooltip'>" + contents + "</div>").css({
				position: "fixed",
				display: "none",
				top: y + 5,
				left: x + 5,
				border: "1px solid #fdd",
				padding: "2px",
				"background-color": "#fee",
				opacity: 0.80
			}).appendTo("body").fadeIn(200);
		}

		var profitPlot;

		function plotAccordingToChoices() {
			var data = [];
			$('#statisticsProfitsCbs').find('input:checked').each(function() {
				var key = $(this).attr('name');
				if (key && zyskiData[key]) {
					data.push(zyskiData[key]);
				}
			});
			if (data.length > 0) {
				$("#statisticsZyski").css('width', (wWW - 200) + 'px');
				$("#statisticsZyski").css('height', (hHH - 80) + 'px');
				profitPlot = $.plot($('#statisticsZyski'), data, {
					legend: false,
					xaxis: {
						mode: 'time',
						minTickSize: [1, 'day'],
					},
					series: {
						lines: {
							show: true
						},
						points: {
							show: true
						}
					},
					grid: {
						hoverable: true
					}
				});
				var previousPoint = null;
				$('#statisticsZyski').bind('plothover', function(event, pos, item) {
					if (item) {
						if (previousPoint != item.dataIndex) {
							previousPoint = item.dataIndex;
							$('#computerTooltipStatistics').css('display', 'none');
							var x = item.datapoint[0],
								y = item.datapoint[1];
							var d = new Date(x);
							var curr_date = d.getDate();
							var curr_month = d.getMonth() + 1;
							var curr_year = d.getFullYear();
							var date = curr_date + '/' + curr_month + '/' + curr_year;
							showTooltip(item.pageX /*-755*/ , item.pageY,
								item.series.label + '<br/>' + date + ': ' + y + ' PLN');
						}
					} else {
						$('#computerTooltipStatistics').css('display', 'none');
						previousPoint = null;
					}
				});
			}
		}
		plotAccordingToChoices();
		var profitSeries = profitPlot.getData();
		for (var i = 0; i < profitSeries.length; ++i)
			$('#statisticsProfitsCbs input[name="' + i + '"]').parent()
			.css('background-color', profitSeries[i].color);
		$('#statisticsProfitsCbs input').click(plotAccordingToChoices);

		// ============================= STATISTIC PLOT ============================

		var dataTics = [];
		var data = [];
		for (var i = 0; i < dataObject.length; i++) {
			data.push([i, dataObject[i].punkty]);
			dataTics.push([i, dataObject[i].nazwa]);
		}

		$("#statisticsRanking").css('width', (wWW - 50) + 'px');
		$("#statisticsRanking").css('height', (hHH - 80) + 'px');
		$.plot($("#statisticsRanking"), colourSeries(data), {
			grid: {
				hoverable: true
			},
			xaxis: {
				mode: "categories",
				tickLength: 0,
				position: 'bottom',
				alignTicksWithAxis: 1,
				ticks: dataTics
			},
			yaxis: {
				position: 'right',
				min: 0
			},
			bars: {
				show: true,
				barWidth: 0.2,
				order: 1,
			},
			legend: true,
		});

		//tooltip function
		function showTooltip(x, y, contents) {
			var toolTip = $('#computerTooltipStatistics');
			toolTip.html(contents);
			toolTip.css({
				position: 'fixed',
				display: 'block',
				top: (y - 120) + 'px',
				left: (x - 160) + 'px',
				'z-index': '9999',
				'color': '#fff',
				'font-size': '11px',
				opacity: 0.8
			});
		}

		var previousPoint;

		//add tooltip event
		$("#statisticsRanking").bind("plothover", function(event, pos, item) {
			if (item) {
				if (previousPoint != item.datapoint) {
					previousPoint = item.datapoint;

					$('#computerTooltipStatistics').css('display', 'none');

					var x = item.datapoint[0];

					//All the bars concerning a same x value must display a tooltip with this value and not the shifted value
					if (item.series.bars.order) {
						for (var i = 0; i < item.series.data.length; i++) {
							if (item.series.data[i][3] == item.datapoint[0])
								x = item.series.data[i][0];
						}
					}

					var y = item.datapoint[1];

					if ($(this).is('#statisticsRanking')) {
						var categoryName = dataTics[item.datapoint[0]][1];
						showTooltip(item.pageX + 5, item.pageY + 5,
							"Firma: " + categoryName + "<br/>Punkty: " + y);
					}
				}
			} else {
				$('#computerTooltipStatistics').css('display', 'none');
				previousPoint = null;
			}
		});
	}
	fx();
}
